package furny.states;

import furny.ga.FurnLayoutIndividual;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.view.appstate.GUIState;
import ga.view.appstate.menu.MenuListener;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.niftygui.NiftyJmeDisplay;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.PanelRenderer;

/**
 * This is an advanced app state which adds gui to the initializer pre state.
 * 
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class InitializerUIState extends GUIState {
  private final InitializerUIController controller;
  private NiftyJmeDisplay niftyDisplay;
  private Nifty nifty;
  private AudioRenderer audioRenderer;

  private final IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator;
  private final InitializerPreState state;

  private MenuListener menuListener;

  /**
   * Instantiates a new initializer ui state.
   * 
   * @param evaluator
   *          the evaluator
   * @param state
   *          the state
   * @param menuListener
   *          the menu listener
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public InitializerUIState(
      final IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator,
      final InitializerPreState state, final MenuListener menuListener) {
    this.evaluator = evaluator;
    this.state = state;
    this.controller = new InitializerUIController(evaluator, state);
    controller.setMenuListener(menuListener);

  }

  /**
   * Gets the ui controller.
   * 
   * @return the controller
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public InitializerUIController getController() {
    return controller;
  }

  @Override
  public void initialize(final AppStateManager stateManager,
      final Application app) {
    super.initialize(stateManager, app);

    this.audioRenderer = app.getAudioRenderer();

    setEnabled(true);

    for (int i = 0; i < 9; i++) {
      final Element niftyElement = nifty.getCurrentScreen().findElementByName(
          "img_" + i);
      // swap old with new text
      niftyElement.getRenderer(ImageRenderer.class).setImage(
          nifty.createImage(controller.getImageFile(i), false));
    }
  }

  /**
   * Updates the view.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void updateView() {
    nifty.getCurrentScreen().findElementByName("Panel_Color")
        .getRenderer(PanelRenderer.class)
        .setBackgroundColor(controller.getColor());

    nifty.getCurrentScreen().findElementByName("roomSizeButton")
        .getNiftyControl(Button.class).setText(controller.getRoomSizeString());

    Button b = nifty.getCurrentScreen()
        .findElementByName("PopPercentageButton").getNiftyControl(Button.class);
    b.setText(controller.getPopPercentageString());

    final boolean enabled = controller.getIndividual() != null;

    b.setEnabled(enabled);

    b = nifty.getCurrentScreen().findElementByName("ResetButton")
        .getNiftyControl(Button.class);
    b.setEnabled(enabled);
  }

  @Override
  public void setEnabled(final boolean enabled) {
    super.setEnabled(enabled);

    if (enabled) {
      niftyDisplay = new NiftyJmeDisplay(assetManager, inputManager,
          audioRenderer, viewPort);
      nifty = niftyDisplay.getNifty();

      nifty.fromXml("furny/ui/initializerUI.xml", "start", controller);

      viewPort.addProcessor(niftyDisplay);

      updateView();
    } else {
      try {
        if (nifty != null) {
          viewPort.removeProcessor(niftyDisplay);
          nifty.exit();
        }
      } catch (final Exception e) {
        // ignore
      }
    }
  }

  @Override
  public void cleanup() {
    try {
      if (nifty != null) {
        viewPort.removeProcessor(niftyDisplay);
        nifty.exit();
      }
    } catch (final Exception e) {
      // ignore
    }
    super.cleanup();
  }
}
